/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.collections.toposort;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class SortableNode<I, N extends SortableNode<I, N>> {
    final Set<N> nextNodes = new HashSet<N>();
    final Set<N> previousNodes = new HashSet<N>();
    boolean visited = false;

    @Contract(pure=true)
    @NotNull
    public abstract I getId();

    @NotNull
    protected @Unmodifiable Set<N> getPreviousNodes() {
        return Set.copyOf(this.previousNodes);
    }

    @ApiStatus.OverrideOnly
    protected void addPreviousNode(@NotNull N node) {
        this.previousNodes.add(node);
    }

    @NotNull
    protected @Unmodifiable Set<N> getNextNodes() {
        return Set.copyOf(this.nextNodes);
    }

    @ApiStatus.OverrideOnly
    protected void addNextNode(@NotNull N node) {
        this.nextNodes.add(node);
    }

    public static <I, N extends SortableNode<I, N>> void link(@NotNull N first, @NotNull N second) {
        if (first == second) {
            throw new IllegalArgumentException("Cannot link a node to itself!");
        }
        first.addNextNode(second);
        second.addPreviousNode(first);
    }
}

